(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     31057,        579]
NotebookOptionsPosition[     30539,        561]
NotebookOutlinePosition[     30970,        578]
CellTagsIndexPosition[     30927,        575]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CountryData", "[", "GGrupoPaises", "]"}], ",", 
       RowBox[{"Row", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<Distancia total: \>\"", ",", 
          RowBox[{
           RowBox[{"FindShortestTour", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"GeoPosition", "[", 
               RowBox[{"CountryData", "[", 
                RowBox[{"#", ",", "\"\<CenterCoordinates\>\""}], "]"}], "]"}],
               "&"}], "/@", " ", 
             RowBox[{"CountryData", "[", "GGrupoPaises", "]"}]}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], " ", "}"}], "]"}], ",", 
       RowBox[{"GeoGraphics", "[", 
        RowBox[{"{", 
         RowBox[{"Thick", ",", " ", "Red", ",", 
          RowBox[{"GeoPath", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"GeoPosition", "[", 
              RowBox[{"CountryData", "[", 
               RowBox[{"#", ",", "\"\<CenterCoordinates\>\""}], "]"}], "]"}], 
             "&"}], "/@", " ", 
            RowBox[{
             RowBox[{"CountryData", "[", "GGrupoPaises", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"Last", "[", 
               RowBox[{"FindShortestTour", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"GeoPosition", "[", 
                   RowBox[{"CountryData", "[", 
                    RowBox[{"#", ",", "\"\<CenterCoordinates\>\""}], "]"}], 
                   "]"}], "&"}], "/@", " ", 
                 RowBox[{"CountryData", "[", "GGrupoPaises", "]"}]}], "]"}], 
               "]"}], "]"}], "]"}]}], "]"}]}], "}"}], "]"}]}], "}"}], ",", 
     "Center"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "GGrupoPaises", ",", "\"\<CentralAmerica\>\"", ",", 
       "\"\<Grupo de pa\[IAcute]ses:\>\""}], "}"}], ",", 
     RowBox[{"GGruposPaisesF", "[", "]"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "PopupMenu"}]}], "}"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"GList18", "=", 
       RowBox[{"CountryData", "[", "\"\<Groups\>\"", "]"}]}], ";", 
      RowBox[{
       RowBox[{"GGruposPaisesF", "[", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GList19", "=", 
           RowBox[{"{", "}"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"Gi30", "=", "1"}], ",", 
            RowBox[{"Gi30", "\[LessEqual]", 
             RowBox[{"Length", "[", "GList18", "]"}]}], ",", 
            RowBox[{
             RowBox[{"GList19", "=", 
              RowBox[{"Append", "[", 
               RowBox[{"GList19", ",", 
                RowBox[{"ToString", "[", 
                 RowBox[{"GList18", "[", 
                  RowBox[{"[", 
                   RowBox[{"Gi30", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}]}],
              ";", 
             RowBox[{"Gi30", "++"}]}]}], "]"}], ";", "GList19"}]}], "]"}]}]}],
      ")"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Column", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Spacer", "[", 
             RowBox[{"{", 
              RowBox[{"400", ",", "2"}], "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Autor: Enrique V\[IAcute]lchez Quesada\>\"", ",", "Bold", 
                ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}], 
              "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica\>\"", ",", "Bold", ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.12", ",", "0", ",", "0.5"}], "]"}]}], "]"}], 
              "}"}], "]"}]}], "}"}], ",", "Center"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Circuitos de Hamilton\>\"", ",", " ", "Bold", ",", " ", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6726676502586727`*^9, 3.67266765026119*^9}, 
   3.6726693020085287`*^9, {3.6726695823244324`*^9, 3.6726695850253906`*^9}, {
   3.6726898149792337`*^9, 3.6726898265710993`*^9}, 3.6726928149892797`*^9, {
   3.8011550973543305`*^9, 3.8011551183441505`*^9}, {3.801155285951089*^9, 
   3.801155288179125*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"e6e54a73-19b4-44c3-9df0-9b609ac5469b"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`GGrupoPaises$$ = "CentralAmerica", 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[$CellContext`GGrupoPaises$$], "CentralAmerica", 
       "Grupo de pa\[IAcute]ses:"}, {
      "Africa", "AfricanCaribbeanAndPacificGroup", "AfricanDevelopmentBank", 
       "AfricanUnion", 
       "AgencyForTheProhibitionOfNuclearWeaponsInLatinAmericaAndTheCaribbean",
        "AgencyOfCulturalAndTechnicalCooperation", 
       "AllianceOfSmallIslandStates", "Americas", "AndeanCommunityOfNations", 
       "AntarcticNations", "ArabBankForEconomicDevelopmentInAfrica", 
       "ArabFundForEconomicAndSocialDevelopment", "Arabia", "ArabicSpeaking", 
       "ArabLeague", "ArabMaghrebUnion", "ArabMonetaryFund", "ArcticCouncil", 
       "ASEANPlus3", "Asia", "AsiaCooperationDialogue", 
       "AsianDevelopmentBank", "AsiaPacific", 
       "AsiaPacificEconomicCooperation", "AsiaPacificTelecommunity", 
       "AsiaWithoutMiddleEast", "AssociationOfCaribbeanStates", 
       "AssociationOfSouthEastAsianNations", 
       "AssociationOfSoutheastAsianNationsRegionalForum", "Australasian", 
       "AustraliaContinent", "AustraliaExtended", "AustraliaGroup", 
       "AustraliaNewZealandUnitedStatesSecurityTreaty", "Balkans", 
       "BalticAssembly", "BalticStates", "BankForInternationalSettlements", 
       "BayOfBengalInitiativeForMultisectoralTechnicalAndEconomicCooperation",
        "BeneluxEconomicUnion", "Bicontinental", "BlackSea", 
       "BlackSeaEconomicCooperationZone", "BRICCountries", 
       "BritishOverseasTerritories", "Caribbean", 
       "CaribbeanCommunityAndCommonMarket", "CaribbeanDevelopmentBank", 
       "CaribbeanDevelopmentBankRegionalMembers", "Caucasus", "CentralAfrica",
        "CentralAfricanStatesDevelopmentBank", "CentralAmerica", 
       "CentralAmericanBankForEconomicIntegration", 
       "CentralAmericanCommonMarket", "CentralAmericanIntegrationSystem", 
       "CentralAmericanParliament", "CentralAmericaWithMexico", "CentralAsia",
        "CentralAsianCooperationOrganization", "CentralEasternEurope", 
       "CentralEurope", "CentralEuropeanInitiative", "ChinaExtended", 
       "ChinaHongKong", "ChinaHongKongMacau", "ChinaMacau", 
       "CollectiveSecurityTreatyOrganization", "ColomboPlan", 
       "CommonMarketForEasternAndSouthernAfrica", "Commonwealth", 
       "CommonwealthOfIndependentStates", 
       "CommunityOfLatinAmericanAndCaribbeanStates", 
       "CommunityOfPortugueseLanguage", "CompactOfFreeAssociation", 
       "ConferenceOfInteractionAndConfidenceBuildingMeasuresInAsia", 
       "ConventionOfTheSoutheastEuropeanLawEnforcementCenter", 
       "CouncilOfAccord", "CouncilOfArabEconomicUnity", "CouncilOfEurope", 
       "CouncilOfTheBalticSeaStates", "Countries", "DanishDependencies", 
       "DanishSpeaking", "DenmarkExtended", "Developing8", 
       "DevelopingCountries", "DoublyLandlocked", "DutchSpeaking", 
       "EastAfrica", "EastAfricanCommunity", "EastAfricanDevelopmentBank", 
       "EastAsia", "EastAsiaSummit", "EastCaribbean", "EasternEurope", 
       "EasternHemisphere", "EconomicAndMonetaryCommunityOfCentralAfrica", 
       "EconomicAndMonetaryUnion", 
       "EconomicAndSocialCommissionForAsiaAndThePacific", 
       "EconomicCommunityOfTheGreatLakesCountries", 
       "EconomicCommunityOfWestAfricanStates", 
       "EconomicCooperationOrganization", "EnglishSpeaking", 
       "EquatorialAfrica", "Eurasia", "EurasianEconomicCommunity", 
       "EuroAtlanticPartnershipCouncil", "Europe", 
       "EuropeanBankForReconstructionAndDevelopment", 
       "EuropeanFreeTradeAssociation", "EuropeanInvestmentBank", 
       "EuropeanMicrostates", "EuropeanOrganizationForNuclearResearch", 
       "EuropeanSpaceAgency", "EuropeanUnion", "EuropeExtended", 
       "EuropeMiddleEastAfrica", "EuropeRussia", "EuropeSovereign", 
       "Eurozone", "FinancialActionTaskForce", "FinnoUgricSpeaking", 
       "FirstWorldCountries", "FoodAndAgricultureOrganization", 
       "FormerBelgianColonies", "FormerBritishColonies", 
       "FormerCzechoslovakiaMembers", "FormerEthiopiaMembers", 
       "FormerItalianColonies", "FormerNetherlandsAntillesMembers", 
       "FormerPortugueseColonies", "FormerSovietUnionMembers", 
       "FormerSpanishColonies", "FormerYugoslaviaMembers", "FranceExtended", 
       "FrancZone", "FrenchSpeaking", "GeneralConfederationOfTradeUnions", 
       "GermanSpeaking", "GreaterAntilles", "GroupOf10", "GroupOf11", 
       "GroupOf15", "GroupOf20", "GroupOf20Seated19", 
       "GroupOf20ThroughEuropeanUnionSeat", "GroupOf24", "GroupOf3", 
       "GroupOf5", "GroupOf6", "GroupOf6EU", "GroupOf7", "GroupOf77", 
       "GroupOf8", "GroupOf9", 
       "GUAMOrganizationForDemocracyAndEconomicDevelopment", 
       "GulfCooperationCouncil", "HornOfAfrica", "IberianPeninsula", 
       "IndianOceanCommission", "IndianOceanRimAssociation", 
       "InterAmericanDevelopmentBank", 
       "InterGovernmentalAuthorityOnDevelopment", 
       "InternationalAtomicEnergyAgency", 
       "InternationalBankForReconstructionAndDevelopment", 
       "InternationalChamberOfCommerce", 
       "InternationalCivilAviationOrganization", 
       "InternationalConfederationOfFreeTradeUnions", 
       "InternationalCriminalCourt", 
       "InternationalCriminalPoliceOrganization", 
       "InternationalDevelopmentAssociation", "InternationalEnergyAgency", 
       "InternationalFederationOfRedCrossAndRedCrescentSocieties", 
       "InternationalFinanceCorporation", 
       "InternationalFundForAgriculturalDevelopment", 
       "InternationalHydrographicOrganization", 
       "InternationalLabourOrganization", "InternationalMaritimeOrganization",
        "InternationalMobileSatelliteOrganization", 
       "InternationalMonetaryFund", "InternationalOlympicCommittee", 
       "InternationalOrganizationForMigration", 
       "InternationalOrganizationForStandardization", 
       "InternationalOrganizationOfTheFrenchSpeakingWorld", 
       "InternationalTelecommunicationsSatellitesOrganization", 
       "InternationalTelecommunicationUnion", 
       "InternationalTradeUnionConfederation", "InterParliamentaryUnion", 
       "IslamicDevelopmentBank", "IslamicRepublics", "IslandNations", 
       "ItalianSpeaking", "ITERParticipants", "KingdomOfTheNetherlands", 
       "Korea", "Landlocked", "LandMasses", "LatinAmerica", 
       "LatinAmericaCaribbean", "LatinAmericanEconomicSystem", 
       "LatinAmericanIntegrationAssociation", "LatinUnion", "LeastDeveloped", 
       "LesserAntilles", "Levant", "Maghreb", "Mashriq", "Mediterranean", 
       "Melanesia", "Mercosur", "Metagea", "MiddleEast", 
       "MultilateralInvestmentGeographicAgency", "Nearctic", "NearEast", 
       "Neotropical", "NetherlandsExtended", "NewZealandExtended", 
       "NonAlignedMovement", "Nordic", "NordicCouncil", 
       "NordicInvestmentBank", "NorthAfrica", "NorthAmerica", 
       "NorthAmericanFreeTradeAgreement", "NorthAtlanticIslands", 
       "NorthAtlanticTreatyOrganization", "NorthernAsia", "NorthernEurope", 
       "NorthernHemisphere", "NorthwesternEurope", "NorwayExtended", 
       "NuclearArmedStates", "NuclearEnergyAgency", "NuclearSuppliersGroup", 
       "Oceania", "OceanicDependencies", "Oceans", 
       "OrganizationForEconomicCooperationAndDevelopment", 
       "OrganizationForSecurityAndCooperationInEurope", 
       "OrganizationForTheProhibitionOfChemicalWeapons", 
       "OrganizationOfAmericanStates", 
       "OrganizationOfArabPetroleumExportingCountries", 
       "OrganizationOfEasternCaribbeanStates", 
       "OrganizationOfIberoAmericanStates", 
       "OrganizationOfPetroleumExportingCountries", 
       "OrganizationOfTheIslamicConference", "Oriental", "PacificAlliance", 
       "PacificIslandsForum", "PacificRim", "Palaearctic", 
       "PalestinianTerritories", "ParisClub", "PartnershipForPeace", 
       "PermanentCourtOfArbitration", "PersianGulf", "Petrocaribe", 
       "PortugueseSpeaking", "RioGroup", "Scandinavia", "SchengenConvention", 
       "SecretariatOfThePacificCommunity", "ShanghaiCooperationOrganization", 
       "SouthAmerica", "SouthAmericanCommunityOfNations", 
       "SouthAndCentralAsia", "SouthAsia", 
       "SouthAsiaCooperativeEnvironmentProgram", 
       "SouthAsianAssociationForRegionalCooperation", "SoutheastAsia", 
       "SoutheastEuropeanCooperativeInitiative", "SouthernAfrica", 
       "SouthernAfricanCustomsUnion", "SouthernAfricanDevelopmentCommunity", 
       "SouthernEurope", "SouthernHemisphere", 
       "SouthPacificRegionalTradeAndEconomicCooperationAgreement", 
       "SouthwestAsia", "SovereignCountries", "SpanishSpeaking", 
       "SubsaharanAfrica", "UNAfricanUnionMissionInDarfur", 
       "UNConferenceOnTradeAndDevelopment", "UNDisengagementObserverForce", 
       "UNEducationalScientificAndCulturalOrganization", 
       "UNFrameworkConventionOnClimateChangeAnnexI", 
       "UNHighCommissionerForRefugees", "UNIndustrialDevelopmentOrganization",
        "UNInstituteForTrainingAndResearch", "UNIntegratedMissionInEastTimor",
        "UNInterimForceInLebanon", "UNInterimSecurityForceInAbyei", 
       "UnionOfSouthAmericanNations", "UnitedKingdomExtended", 
       "UnitedNations", "UnitedStatesExtended", "UniversalPostalUnion", 
       "UNMilitaryObserverGroupInIndiaAndPakistan", 
       "UNMissionForTheReferendumInWesternSahara", 
       "UNMissionInCentralAfricanRepublicAndChad", 
       "UNMissionInEthiopiaAndEritrea", "UNMissionInLiberia", 
       "UNMissionInSierraLeone", "UNMissionInTheSouthSudan", 
       "UNMissionInTheSudan", "UNMonitoringAndVerificationCommission", 
       "UNMultidimensionalIntegratedStabilizationMissionInMali", 
       "UNObserverMissionInGeorgia", "UNOperationInBurundi", 
       "UNOperationInIvoryCoast", 
       "UNOrganizationMissionInTheDemocraticRepublicOfTheCongo", 
       "UNPeaceKeepingForceInCyprus", "UNReliefAndWorksAgency", 
       "UNSecurityCouncil", "UNSecurityCouncilPermanentMembers", 
       "UNStabilizationMissionInHaiti", "UNTruceSupervisionOrganization", 
       "VisegradGroup", "WeimarTriangle", "WestAfrica", 
       "WestAfricanDevelopmentBank", "WestAfricanEconomicAndMonetaryUnion", 
       "WesternAsia", "WesternEurope", "WesternEuropeanUnion", 
       "WesternHemisphere", "WorldConfederationOfLabor", 
       "WorldCustomsOrganization", "WorldFederationOfTradeUnions", 
       "WorldHealthOrganization", "WorldIntellectualPropertyOrganization", 
       "WorldMeteorologicalOrganization", "WorldTourismOrganization", 
       "WorldTradeOrganization", "ZanggerCommittee"}}}, Typeset`size$$ = {
    889., {148.5, 157.5}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`GGrupoPaises$$ = "CentralAmerica"}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Column[{
         CountryData[$CellContext`GGrupoPaises$$], 
         Row[{"Distancia total: ", 
           Part[
            FindShortestTour[
             Map[GeoPosition[
               CountryData[#, "CenterCoordinates"]]& , 
              CountryData[$CellContext`GGrupoPaises$$]]], 1]}], 
         GeoGraphics[{Thick, Red, 
           GeoPath[
            Map[GeoPosition[
              CountryData[#, "CenterCoordinates"]]& , 
             Part[
              CountryData[$CellContext`GGrupoPaises$$], 
              Last[
               FindShortestTour[
                Map[GeoPosition[
                  CountryData[#, "CenterCoordinates"]]& , 
                 CountryData[$CellContext`GGrupoPaises$$]]]]]]]}]}, Center], 
      "Specifications" :> {{{$CellContext`GGrupoPaises$$, "CentralAmerica", 
          "Grupo de pa\[IAcute]ses:"}, {
         "Africa", "AfricanCaribbeanAndPacificGroup", 
          "AfricanDevelopmentBank", "AfricanUnion", 
          "AgencyForTheProhibitionOfNuclearWeaponsInLatinAmericaAndTheCaribbea\
n", "AgencyOfCulturalAndTechnicalCooperation", "AllianceOfSmallIslandStates", 
          "Americas", "AndeanCommunityOfNations", "AntarcticNations", 
          "ArabBankForEconomicDevelopmentInAfrica", 
          "ArabFundForEconomicAndSocialDevelopment", "Arabia", 
          "ArabicSpeaking", "ArabLeague", "ArabMaghrebUnion", 
          "ArabMonetaryFund", "ArcticCouncil", "ASEANPlus3", "Asia", 
          "AsiaCooperationDialogue", "AsianDevelopmentBank", "AsiaPacific", 
          "AsiaPacificEconomicCooperation", "AsiaPacificTelecommunity", 
          "AsiaWithoutMiddleEast", "AssociationOfCaribbeanStates", 
          "AssociationOfSouthEastAsianNations", 
          "AssociationOfSoutheastAsianNationsRegionalForum", "Australasian", 
          "AustraliaContinent", "AustraliaExtended", "AustraliaGroup", 
          "AustraliaNewZealandUnitedStatesSecurityTreaty", "Balkans", 
          "BalticAssembly", "BalticStates", "BankForInternationalSettlements",
           "BayOfBengalInitiativeForMultisectoralTechnicalAndEconomicCooperati\
on", "BeneluxEconomicUnion", "Bicontinental", "BlackSea", 
          "BlackSeaEconomicCooperationZone", "BRICCountries", 
          "BritishOverseasTerritories", "Caribbean", 
          "CaribbeanCommunityAndCommonMarket", "CaribbeanDevelopmentBank", 
          "CaribbeanDevelopmentBankRegionalMembers", "Caucasus", 
          "CentralAfrica", "CentralAfricanStatesDevelopmentBank", 
          "CentralAmerica", "CentralAmericanBankForEconomicIntegration", 
          "CentralAmericanCommonMarket", "CentralAmericanIntegrationSystem", 
          "CentralAmericanParliament", "CentralAmericaWithMexico", 
          "CentralAsia", "CentralAsianCooperationOrganization", 
          "CentralEasternEurope", "CentralEurope", 
          "CentralEuropeanInitiative", "ChinaExtended", "ChinaHongKong", 
          "ChinaHongKongMacau", "ChinaMacau", 
          "CollectiveSecurityTreatyOrganization", "ColomboPlan", 
          "CommonMarketForEasternAndSouthernAfrica", "Commonwealth", 
          "CommonwealthOfIndependentStates", 
          "CommunityOfLatinAmericanAndCaribbeanStates", 
          "CommunityOfPortugueseLanguage", "CompactOfFreeAssociation", 
          "ConferenceOfInteractionAndConfidenceBuildingMeasuresInAsia", 
          "ConventionOfTheSoutheastEuropeanLawEnforcementCenter", 
          "CouncilOfAccord", "CouncilOfArabEconomicUnity", "CouncilOfEurope", 
          "CouncilOfTheBalticSeaStates", "Countries", "DanishDependencies", 
          "DanishSpeaking", "DenmarkExtended", "Developing8", 
          "DevelopingCountries", "DoublyLandlocked", "DutchSpeaking", 
          "EastAfrica", "EastAfricanCommunity", "EastAfricanDevelopmentBank", 
          "EastAsia", "EastAsiaSummit", "EastCaribbean", "EasternEurope", 
          "EasternHemisphere", "EconomicAndMonetaryCommunityOfCentralAfrica", 
          "EconomicAndMonetaryUnion", 
          "EconomicAndSocialCommissionForAsiaAndThePacific", 
          "EconomicCommunityOfTheGreatLakesCountries", 
          "EconomicCommunityOfWestAfricanStates", 
          "EconomicCooperationOrganization", "EnglishSpeaking", 
          "EquatorialAfrica", "Eurasia", "EurasianEconomicCommunity", 
          "EuroAtlanticPartnershipCouncil", "Europe", 
          "EuropeanBankForReconstructionAndDevelopment", 
          "EuropeanFreeTradeAssociation", "EuropeanInvestmentBank", 
          "EuropeanMicrostates", "EuropeanOrganizationForNuclearResearch", 
          "EuropeanSpaceAgency", "EuropeanUnion", "EuropeExtended", 
          "EuropeMiddleEastAfrica", "EuropeRussia", "EuropeSovereign", 
          "Eurozone", "FinancialActionTaskForce", "FinnoUgricSpeaking", 
          "FirstWorldCountries", "FoodAndAgricultureOrganization", 
          "FormerBelgianColonies", "FormerBritishColonies", 
          "FormerCzechoslovakiaMembers", "FormerEthiopiaMembers", 
          "FormerItalianColonies", "FormerNetherlandsAntillesMembers", 
          "FormerPortugueseColonies", "FormerSovietUnionMembers", 
          "FormerSpanishColonies", "FormerYugoslaviaMembers", 
          "FranceExtended", "FrancZone", "FrenchSpeaking", 
          "GeneralConfederationOfTradeUnions", "GermanSpeaking", 
          "GreaterAntilles", "GroupOf10", "GroupOf11", "GroupOf15", 
          "GroupOf20", "GroupOf20Seated19", 
          "GroupOf20ThroughEuropeanUnionSeat", "GroupOf24", "GroupOf3", 
          "GroupOf5", "GroupOf6", "GroupOf6EU", "GroupOf7", "GroupOf77", 
          "GroupOf8", "GroupOf9", 
          "GUAMOrganizationForDemocracyAndEconomicDevelopment", 
          "GulfCooperationCouncil", "HornOfAfrica", "IberianPeninsula", 
          "IndianOceanCommission", "IndianOceanRimAssociation", 
          "InterAmericanDevelopmentBank", 
          "InterGovernmentalAuthorityOnDevelopment", 
          "InternationalAtomicEnergyAgency", 
          "InternationalBankForReconstructionAndDevelopment", 
          "InternationalChamberOfCommerce", 
          "InternationalCivilAviationOrganization", 
          "InternationalConfederationOfFreeTradeUnions", 
          "InternationalCriminalCourt", 
          "InternationalCriminalPoliceOrganization", 
          "InternationalDevelopmentAssociation", "InternationalEnergyAgency", 
          "InternationalFederationOfRedCrossAndRedCrescentSocieties", 
          "InternationalFinanceCorporation", 
          "InternationalFundForAgriculturalDevelopment", 
          "InternationalHydrographicOrganization", 
          "InternationalLabourOrganization", 
          "InternationalMaritimeOrganization", 
          "InternationalMobileSatelliteOrganization", 
          "InternationalMonetaryFund", "InternationalOlympicCommittee", 
          "InternationalOrganizationForMigration", 
          "InternationalOrganizationForStandardization", 
          "InternationalOrganizationOfTheFrenchSpeakingWorld", 
          "InternationalTelecommunicationsSatellitesOrganization", 
          "InternationalTelecommunicationUnion", 
          "InternationalTradeUnionConfederation", "InterParliamentaryUnion", 
          "IslamicDevelopmentBank", "IslamicRepublics", "IslandNations", 
          "ItalianSpeaking", "ITERParticipants", "KingdomOfTheNetherlands", 
          "Korea", "Landlocked", "LandMasses", "LatinAmerica", 
          "LatinAmericaCaribbean", "LatinAmericanEconomicSystem", 
          "LatinAmericanIntegrationAssociation", "LatinUnion", 
          "LeastDeveloped", "LesserAntilles", "Levant", "Maghreb", "Mashriq", 
          "Mediterranean", "Melanesia", "Mercosur", "Metagea", "MiddleEast", 
          "MultilateralInvestmentGeographicAgency", "Nearctic", "NearEast", 
          "Neotropical", "NetherlandsExtended", "NewZealandExtended", 
          "NonAlignedMovement", "Nordic", "NordicCouncil", 
          "NordicInvestmentBank", "NorthAfrica", "NorthAmerica", 
          "NorthAmericanFreeTradeAgreement", "NorthAtlanticIslands", 
          "NorthAtlanticTreatyOrganization", "NorthernAsia", "NorthernEurope",
           "NorthernHemisphere", "NorthwesternEurope", "NorwayExtended", 
          "NuclearArmedStates", "NuclearEnergyAgency", 
          "NuclearSuppliersGroup", "Oceania", "OceanicDependencies", "Oceans",
           "OrganizationForEconomicCooperationAndDevelopment", 
          "OrganizationForSecurityAndCooperationInEurope", 
          "OrganizationForTheProhibitionOfChemicalWeapons", 
          "OrganizationOfAmericanStates", 
          "OrganizationOfArabPetroleumExportingCountries", 
          "OrganizationOfEasternCaribbeanStates", 
          "OrganizationOfIberoAmericanStates", 
          "OrganizationOfPetroleumExportingCountries", 
          "OrganizationOfTheIslamicConference", "Oriental", "PacificAlliance",
           "PacificIslandsForum", "PacificRim", "Palaearctic", 
          "PalestinianTerritories", "ParisClub", "PartnershipForPeace", 
          "PermanentCourtOfArbitration", "PersianGulf", "Petrocaribe", 
          "PortugueseSpeaking", "RioGroup", "Scandinavia", 
          "SchengenConvention", "SecretariatOfThePacificCommunity", 
          "ShanghaiCooperationOrganization", "SouthAmerica", 
          "SouthAmericanCommunityOfNations", "SouthAndCentralAsia", 
          "SouthAsia", "SouthAsiaCooperativeEnvironmentProgram", 
          "SouthAsianAssociationForRegionalCooperation", "SoutheastAsia", 
          "SoutheastEuropeanCooperativeInitiative", "SouthernAfrica", 
          "SouthernAfricanCustomsUnion", 
          "SouthernAfricanDevelopmentCommunity", "SouthernEurope", 
          "SouthernHemisphere", 
          "SouthPacificRegionalTradeAndEconomicCooperationAgreement", 
          "SouthwestAsia", "SovereignCountries", "SpanishSpeaking", 
          "SubsaharanAfrica", "UNAfricanUnionMissionInDarfur", 
          "UNConferenceOnTradeAndDevelopment", "UNDisengagementObserverForce",
           "UNEducationalScientificAndCulturalOrganization", 
          "UNFrameworkConventionOnClimateChangeAnnexI", 
          "UNHighCommissionerForRefugees", 
          "UNIndustrialDevelopmentOrganization", 
          "UNInstituteForTrainingAndResearch", 
          "UNIntegratedMissionInEastTimor", "UNInterimForceInLebanon", 
          "UNInterimSecurityForceInAbyei", "UnionOfSouthAmericanNations", 
          "UnitedKingdomExtended", "UnitedNations", "UnitedStatesExtended", 
          "UniversalPostalUnion", "UNMilitaryObserverGroupInIndiaAndPakistan",
           "UNMissionForTheReferendumInWesternSahara", 
          "UNMissionInCentralAfricanRepublicAndChad", 
          "UNMissionInEthiopiaAndEritrea", "UNMissionInLiberia", 
          "UNMissionInSierraLeone", "UNMissionInTheSouthSudan", 
          "UNMissionInTheSudan", "UNMonitoringAndVerificationCommission", 
          "UNMultidimensionalIntegratedStabilizationMissionInMali", 
          "UNObserverMissionInGeorgia", "UNOperationInBurundi", 
          "UNOperationInIvoryCoast", 
          "UNOrganizationMissionInTheDemocraticRepublicOfTheCongo", 
          "UNPeaceKeepingForceInCyprus", "UNReliefAndWorksAgency", 
          "UNSecurityCouncil", "UNSecurityCouncilPermanentMembers", 
          "UNStabilizationMissionInHaiti", "UNTruceSupervisionOrganization", 
          "VisegradGroup", "WeimarTriangle", "WestAfrica", 
          "WestAfricanDevelopmentBank", "WestAfricanEconomicAndMonetaryUnion",
           "WesternAsia", "WesternEurope", "WesternEuropeanUnion", 
          "WesternHemisphere", "WorldConfederationOfLabor", 
          "WorldCustomsOrganization", "WorldFederationOfTradeUnions", 
          "WorldHealthOrganization", "WorldIntellectualPropertyOrganization", 
          "WorldMeteorologicalOrganization", "WorldTourismOrganization", 
          "WorldTradeOrganization", "ZanggerCommittee"}, ControlType -> 
         PopupMenu}}, "Options" :> {FrameLabel -> {{None, None}, {
           Column[{
             Spacer[{400, 2}], 
             Row[{
               Style["Autor: Enrique V\[IAcute]lchez Quesada", Bold, 10, 
                RGBColor[0, 0.333333, 0]]}], 
             Row[{
               Style[
               "Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica", Bold, 10, 
                RGBColor[0.12, 0, 0.5]]}]}, Center], 
           Style["Circuitos de Hamilton", Bold, 
            RGBColor[0, 0.333333, 0]]}}}, "DefaultOptions" :> {}],
     ImageSizeCache->{961., {270., 279.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`GList18 = 
       CountryData["Groups"]; $CellContext`GGruposPaisesF[] := 
       Module[{$CellContext`GList19 = {}}, 
         For[$CellContext`Gi30 = 1, $CellContext`Gi30 <= 
           Length[$CellContext`GList18], $CellContext`GList19 = 
            Append[$CellContext`GList19, 
              ToString[
               Part[$CellContext`GList18, $CellContext`Gi30, 2]]]; 
           Increment[$CellContext`Gi30]]; $CellContext`GList19]); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.672669586446354*^9, 3.6726695932341967`*^9}, 
   3.6726898285423126`*^9, 3.6726928165908012`*^9, 3.8011552437228956`*^9, 
   3.8011552910584555`*^9, 3.801155330725684*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"d2907cba-6cd3-44de-8736-6817cabae8f1"]
}, Open  ]]
},
WindowSize->{1366, 685},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"06051988-584c-4a43-bd75-3d50e9259c0a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 5030, 124, 1208, "Input",ExpressionUUID->"e6e54a73-19b4-44c3-9df0-9b609ac5469b"],
Cell[5613, 148, 24910, 410, 618, "Output",ExpressionUUID->"d2907cba-6cd3-44de-8736-6817cabae8f1"]
}, Open  ]]
}
]
*)

